/*
The Keccak sponge function, designed by Guido Bertoni, Joan Daemen,
Michaël Peeters and Gilles Van Assche. For more information, feedback or
questions, please refer to our website: http://keccak.noekeon.org/

Implementation by Ronny Van Keer,
hereby denoted as "the implementer".

To the extent possible under law, the implementer has waived all copyright
and related or neighboring rights to the source code in this file.
http://creativecommons.org/publicdomain/zero/1.0/
*/

#include "KeccakF-1600-interface.h"
#include "KeccakNISTInterface.h"
#include "string.h"

typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned int UINT32;

int main()
{
    UINT32 x = 0;
    int i;
	{
	    UINT32 state[50];
	    const UINT32 imageOfAllZero[50] = {
	        0xD33D89FB, 0xC4B60CAD, 0x2FAD58B0, 0x88AE581B, 0xF4262C1A, 
	        0x8A53D3EF, 0x77B4B09B, 0xE0147822, 0x10A38DCF, 0xB6305181, 
	        0xF723F2BE, 0xF9C67B78, 0x4EB02ABA, 0x8FCCC118, 0x2DC2E52E, 
	        0xA3B29275, 0x342F5536, 0xE4DD320A, 0x45C7C3EA, 0x493D8BE4, 
	        0x9C1717E7, 0xF3E75194, 0x12A23D11, 0xEDD52441, 0x13E6DBFF, 
	        0x8C61BB03, 0x945B1B82, 0x1E4A11A5, 0x1C3453E7, 0x0D730C1B, 
	        0x3B9C1D29, 0x0C534AF4, 0xA6EC29CC, 0x4FFDAA4D, 0x96C7DAA5, 
	        0x45487850, 0x4ECFBC29, 0xE630383B, 0x26806B48, 0xA7EB2B5A,
	        0x62D02426, 0x8265F750, 0x49D20B1A, 0x20E4D82C, 0x6F72B2B8, 
	        0x1C45D049, 0xFEA9F415, 0x4D0E74C7, 0x8DFDEA09, 0xFCF72ED2 };

		// Test 1 (all-zero state through Keccak-f[1600])
	    memset(state, 0, 50*sizeof(UINT32));
		KeccakPermutation((unsigned char*)state);
	    for(i=0; i<50; i++)
	        if (state[i] != imageOfAllZero[i])
	            for( ; ; ) {
					//	Kaccek (aka other algo)
	                x++;
	            }
		// For benchmarking
		{
			#ifdef ProvideFast1024
			KeccakAbsorb1024bits((unsigned char*)state, (unsigned char*)imageOfAllZero);
			#else
			KeccakAbsorb((unsigned char*)state, (unsigned char*)imageOfAllZero, 16);
			#endif
		}
	}
	{
		hashState state;
		const UINT8 Msg29[4] = { 0x53, 0x58, 0x7B, 0xC8 };
		const UINT8 Msg29_out[160] = {
			0x2F, 0x07, 0xBF, 0x03, 0xB8, 0x24, 0x66, 0x46, 0x3A, 0xC4, 0xD3, 0xD2, 0xDA, 0x12, 0xEC, 0xD3, 
			0x47, 0xFF, 0xCF, 0x41, 0x7D, 0xF6, 0x1C, 0x2F, 0x3A, 0x67, 0x82, 0xB7, 0x49, 0xE6, 0x4C, 0xEC, 
			0x15, 0x94, 0x46, 0xBD, 0x20, 0x1D, 0xC8, 0x79, 0x71, 0x8C, 0xEF, 0x77, 0x5A, 0xE7, 0x20, 0xA1, 
			0x83, 0x8B, 0xB9, 0x00, 0x66, 0x42, 0x21, 0xE0, 0x8A, 0x68, 0x9C, 0xC8, 0xB4, 0x70, 0x27, 0x61, 
			0x8D, 0xD1, 0xBA, 0x16, 0x7D, 0xB0, 0x7C, 0x3E, 0x9F, 0xFD, 0x86, 0xF6, 0x88, 0xA5, 0x76, 0x2D, 
			0xBC, 0x07, 0xD8, 0x7D, 0x7C, 0xC9, 0x3A, 0xA8, 0x5E, 0x33, 0xC6, 0x53, 0xF7, 0x84, 0xD3, 0xB8, 
			0x99, 0x7F, 0x0B, 0x87, 0x10, 0xD2, 0xEF, 0xFB, 0xFE, 0x2E, 0x5E, 0x45, 0x4B, 0x83, 0x4E, 0x43, 
			0xF2, 0x57, 0xFE, 0xB0, 0xE0, 0xB4, 0xCA, 0xAF, 0x94, 0xF8, 0x5D, 0x21, 0x24, 0xDD, 0x41, 0x53, 
			0x02, 0x3F, 0x15, 0xF9, 0xD7, 0x40, 0x33, 0x99, 0x7B, 0x73, 0x05, 0x34, 0x00, 0xD2, 0x5C, 0x58, 
			0x1F, 0x46, 0xC3, 0xA8, 0x41, 0x96, 0x2E, 0xBF, 0xDF, 0x3D, 0x75, 0x98, 0x50, 0xCA, 0xAA, 0x9D };
		UINT8 output[160];

		// Test 2 (message of length 29 from ShortMsgKAT_0.txt)
		Init(&state, 0);
		Update(&state, Msg29, 29);
		Final(&state, 0);
		Squeeze(&state, output, 160*8);
	    for(i=0; i<160; i++)
	        if (output[i] != Msg29_out[i])
	            for( ; ; ) {
					//	Kaccek (aka other algo)
	                x++;
	            }
	}

	for ( ; ; ) ;
}
