/*
The Keccak sponge function, designed by Guido Bertoni, Joan Daemen,
Michaël Peeters and Gilles Van Assche. For more information, feedback or
questions, please refer to our website: http://keccak.noekeon.org/

Implementation by Ronny Van Keer,
hereby denoted as "the implementer".

To the extent possible under law, the implementer has waived all copyright
and related or neighboring rights to the source code in this file.
http://creativecommons.org/publicdomain/zero/1.0/
*/

#include "Keccak-inplace-settings.h"
#include "string.h"

#define MIN(a,b)	(((a) < (b)) ? (a) : (b))

#define	MAX_INPUT_LEN	(4096/8)


typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned int UINT32;
typedef unsigned long long int UINT64;

int crypto_hash( unsigned char *out, const unsigned char *in, unsigned long long inlen );
void check_result( UINT8 * result, const UINT8 * reference, UINT32 nbBytes );

#if	(cKeccakR == 1024)

//	Some crypto_hash test vectors

const UINT8 outputSize0[128] = {
	0x67, 0x53, 0xE3, 0x38, 0x0C, 0x09, 0xE3, 0x85, 0xD0, 0x33, 0x9E, 0xB6, 0xB0, 0x50, 0xA6, 0x8F, 
	0x66, 0xCF, 0xD6, 0x0A, 0x73, 0x47, 0x6E, 0x6F, 0xD6, 0xAD, 0xEB, 0x72, 0xF5, 0xED, 0xD7, 0xC6, 
	0xF0, 0x4A, 0x5D, 0x01, 0x7A, 0x19, 0xCB, 0xE2, 0x91, 0x93, 0x58, 0x55, 0xB4, 0x86, 0x0F, 0x69, 
	0xDF, 0x04, 0xC9, 0x8A, 0xA7, 0x8B, 0x40, 0x7A, 0x9B, 0xA9, 0x82, 0x6F, 0x72, 0x66, 0xEF, 0x14, 
	0xBA, 0x6D, 0x3F, 0x90, 0xC4, 0xFE, 0x15, 0x4D, 0x27, 0xC2, 0x85, 0x8E, 0xA6, 0xDB, 0x8C, 0x11, 
	0x74, 0x11, 0xA1, 0xBC, 0x5C, 0x49, 0x94, 0x10, 0xC3, 0x91, 0xB2, 0x98, 0xF3, 0x7B, 0xF6, 0x36, 
	0xB0, 0xF5, 0xC3, 0x1D, 0xBD, 0x64, 0x87, 0xA7, 0xD3, 0xD8, 0xCF, 0x2A, 0x97, 0xB6, 0x19, 0x69, 
	0x7E, 0x66, 0xD8, 0x94, 0x29, 0x9B, 0x8B, 0x4D, 0x80, 0xE0, 0x49, 0x85, 0x38, 0xE1, 0x85, 0x44
};

const UINT8 inputSize1[1] = { 0xCC };

const UINT8 outputSize1[128] = {
	0x56, 0xB9, 0x70, 0x29, 0xB4, 0x79, 0xFF, 0x5D, 0xD1, 0x5F, 0x17, 0xD1, 0x29, 0x83, 0xE3, 0xB8, 
	0x35, 0xBB, 0x05, 0x31, 0xD9, 0xB8, 0xD4, 0x9B, 0x10, 0x3B, 0x02, 0x5C, 0xA5, 0x3F, 0x99, 0x17, 
	0x41, 0x29, 0x8E, 0x96, 0x1D, 0x1F, 0xAD, 0x00, 0xFC, 0x36, 0x5C, 0x77, 0x61, 0xBF, 0xB2, 0x78, 
	0xAE, 0x47, 0x39, 0x80, 0xD6, 0x12, 0xC1, 0x62, 0x9E, 0x07, 0x5A, 0x3F, 0xDB, 0xAE, 0x7F, 0x82, 
	0xB0, 0xF0, 0xAF, 0x54, 0xDF, 0x18, 0x7F, 0x35, 0x88, 0x52, 0xE1, 0x9E, 0xA4, 0x34, 0x7C, 0xF5, 
	0xCE, 0xEA, 0x67, 0x6A, 0x1D, 0xCE, 0x3A, 0x47, 0x44, 0x7E, 0x23, 0x7F, 0xD7, 0x42, 0x04, 0xF9, 
	0xA4, 0xB7, 0xF7, 0xC9, 0xCC, 0x7C, 0xC8, 0xB8, 0x65, 0xB1, 0xD5, 0x54, 0xE2, 0xF5, 0xF4, 0xA8, 
	0xEE, 0x17, 0xDB, 0xDD, 0xE7, 0x26, 0x78, 0x94, 0x55, 0x8A, 0x20, 0x97, 0x2C, 0x9E, 0xB6, 0xCF
};


const UINT8 inputSize128[] = { 
	0x2B, 0x6D, 0xB7, 0xCE, 0xD8, 0x66, 0x5E, 0xBE, 0x9D, 0xEB, 0x08, 0x02, 0x95, 0x21, 0x84, 0x26, 
	0xBD, 0xAA, 0x7C, 0x6D, 0xA9, 0xAD, 0xD2, 0x08, 0x89, 0x32, 0xCD, 0xFF, 0xBA, 0xA1, 0xC1, 0x41, 
	0x29, 0xBC, 0xCD, 0xD7, 0x0F, 0x36, 0x9E, 0xFB, 0x14, 0x92, 0x85, 0x85, 0x8D, 0x2B, 0x1D, 0x15, 
	0x5D, 0x14, 0xDE, 0x2F, 0xDB, 0x68, 0x0A, 0x8B, 0x02, 0x72, 0x84, 0x05, 0x51, 0x82, 0xA0, 0xCA, 
	0xE2, 0x75, 0x23, 0x4C, 0xC9, 0xC9, 0x28, 0x63, 0xC1, 0xB4, 0xAB, 0x66, 0xF3, 0x04, 0xCF, 0x06, 
	0x21, 0xCD, 0x54, 0x56, 0x5F, 0x5B, 0xFF, 0x46, 0x1D, 0x3B, 0x46, 0x1B, 0xD4, 0x0D, 0xF2, 0x81, 
	0x98, 0xE3, 0x73, 0x25, 0x01, 0xB4, 0x86, 0x0E, 0xAD, 0xD5, 0x03, 0xD2, 0x6D, 0x6E, 0x69, 0x33, 
	0x8F, 0x4E, 0x04, 0x56, 0xE9, 0xE9, 0xBA, 0xF3, 0xD8, 0x27, 0xAE, 0x68, 0x5F, 0xB1, 0xD8, 0x17
};

const UINT8 outputSize128[128] = {
	0xDC, 0xAC, 0x84, 0x56, 0x8F, 0x15, 0xCA, 0xC0, 0x76, 0x85, 0x4E, 0xA6, 0x92, 0xDE, 0x95, 0xE4, 
	0x73, 0x76, 0x8A, 0x99, 0xDF, 0x9A, 0xC2, 0x32, 0x8E, 0xE4, 0x23, 0xD0, 0x2E, 0xEB, 0x8E, 0xE8, 
	0xE1, 0xD1, 0x70, 0x62, 0x13, 0xC4, 0x41, 0x5D, 0xC7, 0xAA, 0xFA, 0x66, 0x47, 0x6D, 0x8E, 0xBD, 
	0xDD, 0xD8, 0xBF, 0x39, 0xE1, 0xDE, 0x05, 0xCA, 0x76, 0xC3, 0x6E, 0x7E, 0x97, 0x56, 0x29, 0x33, 
	0x1F, 0x3A, 0x33, 0xC3, 0xCA, 0x40, 0x91, 0xC8, 0x20, 0x04, 0xE5, 0x89, 0x1B, 0x7E, 0x27, 0x6D, 
	0x46, 0x42, 0xEA, 0x61, 0xBD, 0xE0, 0x21, 0x87, 0x1C, 0x9B, 0x5C, 0x8C, 0xFA, 0x82, 0x14, 0x4B, 
	0x7A, 0x41, 0x44, 0xB4, 0x4E, 0xBE, 0x60, 0x93, 0xE9, 0x5C, 0x59, 0x30, 0x5F, 0xD3, 0x6A, 0x87, 
	0x41, 0xC4, 0xF2, 0xDF, 0x65, 0xCB, 0x0B, 0x59, 0xF8, 0x03, 0xCF, 0xDC, 0xF2, 0xCE, 0x4B, 0x8B, 
};

const UINT8 inputSize255[] = { 
	0x3A, 0x3A, 0x81, 0x9C, 0x48, 0xEF, 0xDE, 0x2A, 0xD9, 0x14, 0xFB, 0xF0, 0x0E, 0x18, 0xAB, 0x6B, 
	0xC4, 0xF1, 0x45, 0x13, 0xAB, 0x27, 0xD0, 0xC1, 0x78, 0xA1, 0x88, 0xB6, 0x14, 0x31, 0xE7, 0xF5, 
	0x62, 0x3C, 0xB6, 0x6B, 0x23, 0x34, 0x67, 0x75, 0xD3, 0x86, 0xB5, 0x0E, 0x98, 0x2C, 0x49, 0x3A, 
	0xDB, 0xBF, 0xC5, 0x4B, 0x9A, 0x3C, 0xD3, 0x83, 0x38, 0x23, 0x36, 0xA1, 0xA0, 0xB2, 0x15, 0x0A, 
	0x15, 0x35, 0x8F, 0x33, 0x6D, 0x03, 0xAE, 0x18, 0xF6, 0x66, 0xC7, 0x57, 0x3D, 0x55, 0xC4, 0xFD, 
	0x18, 0x1C, 0x29, 0xE6, 0xCC, 0xFD, 0xE6, 0x3E, 0xA3, 0x5F, 0x0A, 0xDF, 0x58, 0x85, 0xCF, 0xC0, 
	0xA3, 0xD8, 0x4A, 0x2B, 0x2E, 0x4D, 0xD2, 0x44, 0x96, 0xDB, 0x78, 0x9E, 0x66, 0x31, 0x70, 0xCE, 
	0xF7, 0x47, 0x98, 0xAA, 0x1B, 0xBC, 0xD4, 0x57, 0x4E, 0xA0, 0xBB, 0xA4, 0x04, 0x89, 0xD7, 0x64, 
	0xB2, 0xF8, 0x3A, 0xAD, 0xC6, 0x6B, 0x14, 0x8B, 0x4A, 0x0C, 0xD9, 0x52, 0x46, 0xC1, 0x27, 0xD5, 
	0x87, 0x1C, 0x4F, 0x11, 0x41, 0x86, 0x90, 0xA5, 0xDD, 0xF0, 0x12, 0x46, 0xA0, 0xC8, 0x0A, 0x43, 
	0xC7, 0x00, 0x88, 0xB6, 0x18, 0x36, 0x39, 0xDC, 0xFD, 0xA4, 0x12, 0x5B, 0xD1, 0x13, 0xA8, 0xF4, 
	0x9E, 0xE2, 0x3E, 0xD3, 0x06, 0xFA, 0xAC, 0x57, 0x6C, 0x3F, 0xB0, 0xC1, 0xE2, 0x56, 0x67, 0x1D, 
	0x81, 0x7F, 0xC2, 0x53, 0x4A, 0x52, 0xF5, 0xB4, 0x39, 0xF7, 0x2E, 0x42, 0x4D, 0xE3, 0x76, 0xF4, 
	0xC5, 0x65, 0xCC, 0xA8, 0x23, 0x07, 0xDD, 0x9E, 0xF7, 0x6D, 0xA5, 0xB7, 0xC4, 0xEB, 0x7E, 0x08, 
	0x51, 0x72, 0xE3, 0x28, 0x80, 0x7C, 0x02, 0xD0, 0x11, 0xFF, 0xBF, 0x33, 0x78, 0x53, 0x78, 0xD7, 
	0x9D, 0xC2, 0x66, 0xF6, 0xA5, 0xBE, 0x6B, 0xB0, 0xE4, 0xA9, 0x2E, 0xCE, 0xEB, 0xAE, 0xB1
};

const UINT8 outputSize255[128] = {
	0x94, 0x35, 0xFC, 0x67, 0x1D, 0xFC, 0xFC, 0xDA, 0xC1, 0x49, 0x27, 0x7E, 0x2C, 0xAA, 0xA8, 0x0E, 
	0xD3, 0xD4, 0xA2, 0x35, 0x93, 0x00, 0xDB, 0x89, 0x2B, 0x80, 0x93, 0xDF, 0xFA, 0x94, 0x42, 0xBB, 
	0x5C, 0x08, 0xF2, 0x42, 0xF2, 0xFC, 0x2C, 0xB5, 0xF8, 0x38, 0x80, 0x32, 0x29, 0x9F, 0x1D, 0xF4, 
	0x7A, 0x57, 0x48, 0x9A, 0x4F, 0xC0, 0xD6, 0x6D, 0x88, 0xE4, 0x83, 0x09, 0x23, 0x20, 0xA4, 0x71, 
	0x89, 0x7F, 0xB6, 0xAD, 0xE6, 0x78, 0x97, 0xE5, 0x13, 0x8C, 0x45, 0xF1, 0x91, 0x74, 0xA4, 0xB1, 
	0xAE, 0x0E, 0x51, 0x0F, 0xA3, 0x90, 0x82, 0x5D, 0x17, 0x56, 0x89, 0x89, 0xC3, 0x65, 0x9F, 0xC5, 
	0x7B, 0x93, 0x45, 0xD7, 0xD9, 0x3E, 0xE5, 0x88, 0xCB, 0x26, 0x29, 0xC5, 0x77, 0x08, 0x08, 0x19, 
	0x52, 0x57, 0xBB, 0xF4, 0x2B, 0x06, 0x95, 0x76, 0xD9, 0x40, 0x11, 0x98, 0x9D, 0xC6, 0xEB, 0xC4
};

#endif

#if		(cKeccakR == 1152)

//All-in-one test for Keccak[r=1152, c=448]
const UINT8	testVectorAccumulated[128] = 
"\x02\x57\x78\x6E\xA6\xA0\x75\xC2\xD1\x16\x7E\x19\x8B\xD6\x60\x3D\xC9\x2D\x31\xD9\xF2\x24\x94\x3E\x10\xBE\x2D\x77\x2F\xFC\xB6\xCE\xAE\x69\xB0\x30\xA0\xC2\xE2\x40\xB4\xAA\x7E\x42\x64\x8D\x88\x1E\x98\x0B\xC5\x2D\x9B\x64\x9B\x03\x10\x08\xF8\x0C\x71\x11\x69\x2B\xB9\x2A\xB8\x6E\x14\x93\xAC\xFE\xEB\xF8\x73\x9B\x59\x65\x47\xE5\xDC\xE0\x29\x21\xD7\xF4\x84\x93\xC9\xBD\xB8\x97\x98\xD5\x69\x15\x38\x1A\x8F\x86\xB2\xAD\xC7\xD2\x63\x43\x69\xDD\x9E\x8A\x27\x58\xEE\xF9\x7B\xA1\x6D\xCC\xFE\x98\x2A\x64\xC5\x1D\x83\xDF\x68\x55";

#elif	(cKeccakR == 1088)

//All-in-one test for Keccak[r=1088, c=512]
const UINT8	testVectorAccumulated[128] = 
"\xD2\x53\x12\x20\x01\x89\x0C\x19\xCE\x06\x9D\x1A\xBE\x36\x7E\xBA\x43\x80\x14\xA1\xCA\xA4\xB3\x99\xAD\xBB\x9B\x1A\xD3\xDE\xA8\xE6\xE3\x44\xDC\xBA\x44\xB1\x5C\x52\x47\x32\xE0\x0F\xDF\x55\x15\x7B\xD3\x49\x0B\xD2\x58\x7D\xC0\x1E\x93\x1E\x8F\xFF\x28\xDC\x7F\x00\xE6\xDF\xD3\xBB\xDC\x94\x05\x5A\xA1\x5B\xB3\x29\x86\x25\x26\x3D\xC6\xB1\xEF\x3B\x89\x18\x20\x71\x92\xFA\xA7\x58\xA4\x8A\xF9\xFF\x19\x61\x96\xC4\x73\x91\x85\xF3\x19\x73\xE3\x52\x6D\xBD\x0A\xD9\xF8\x95\x68\x43\x31\x50\x90\xD7\x68\x5F\x75\xA1\x61\x1E\x08\x2D";

#elif	(cKeccakR == 1024)

//All-in-one test for Keccak[r=1024, c=576]
const UINT8	testVectorAccumulated[128] = 
"\x74\x00\x1E\xA7\xD2\xBE\x68\x0D\x36\x0C\x80\x0D\x6D\xDB\x4D\x07\x01\x10\xE5\x19\x99\x8C\x0C\x1C\x63\xCD\x5C\xC0\x2D\xC3\x12\x4C\x9C\xD1\xC1\x5A\x8E\xC9\x06\xA8\x1E\xE6\x02\x77\x14\x40\x38\xD5\x09\x89\xE2\x2D\xF2\x66\x37\x4A\x48\xBC\xB9\xE2\x7D\x53\x86\xAC\x1F\x3D\x4C\xEF\x4E\x90\x97\xFB\x9C\x45\x40\xED\xAB\x16\x29\x05\x87\x17\x26\xE8\xBD\xFA\x82\x72\x5F\x77\xFF\xFA\x26\xE6\x50\x0B\x1D\x40\x25\x62\xC7\xEE\xCA\xAA\x38\x78\x52\xE6\x15\x7B\xC7\x3E\x16\xB2\xFE\x05\xB8\x8D\x68\x0C\x18\xC1\x48\x0B\x50\x97\xD9\xC7";

#elif	(cKeccakR == 832)

//All-in-one test for Keccak[r=832, c=768]
const UINT8	testVectorAccumulated[128] = 
"\x6C\x07\xDB\x71\x61\x77\xCC\x99\xFF\xB4\x79\xA1\x54\xDC\xA7\xDA\x42\x6D\x5C\x04\x26\xBF\x01\xA2\x93\x9A\x35\xB1\xCC\x2E\x6C\x5D\xBA\x5E\x43\xAD\xD1\x7C\xA8\x45\xF5\x49\xA7\x02\xA3\x84\x4B\x7A\x15\x2B\x23\x9E\x41\xA7\x4C\x83\x09\x04\xF1\xBB\x40\x17\x7A\x67\x72\x3C\xF4\x28\x4B\xAB\x94\xC2\x02\xF4\x7B\x28\xB4\x5D\x57\xCA\x7E\x3F\x27\x0D\x2C\x09\x4F\x68\x54\xA3\xE6\x38\xF3\x82\x25\x0B\xC3\x16\x52\x2B\x8A\xDE\x93\x4F\x10\xC5\x21\x57\x4B\x21\xE7\xC6\xF6\xBB\x84\xF1\x7A\x78\x8E\xD3\x9E\xE2\xC7\x2F\xE3\x0F\xBB\x60";

#elif	(cKeccakR == 576)

//All-in-one test for Keccak[r=576, c=1024]
const UINT8	testVectorAccumulated[128] = 
"\xFB\x00\xFB\x55\x4B\xDA\x9D\x59\xD7\xD4\x42\x9A\xAB\xA5\x19\xA4\x14\x8D\x48\x67\xF6\xF0\xC8\x54\x1A\x48\xA4\x33\x4E\x68\xB7\xF0\x59\x13\x07\xED\xE3\x93\xE1\xA3\xA4\x79\x9E\x94\xDE\x9C\x32\x8A\xBB\x4F\xF2\x75\x47\xB0\x5E\x41\x7D\x78\xF6\x22\x0D\x83\x22\xC6\xB0\x7D\xBD\x2F\xB8\x5F\x4D\x99\x50\x86\xA5\x9B\x03\x51\x56\x35\x94\xB6\xFE\x72\x2B\x63\x7B\x4A\xDC\xDD\xA1\x83\xCF\xB7\xE7\xB2\x9D\x3A\x0D\x29\xBD\x30\xD4\xC5\x9F\x30\xBB\x60\x5A\x52\xC3\x83\x4B\xCA\xF4\x7D\x67\x37\x99\xBA\x28\x2E\xBC\x37\x76\xB3\x53\x56";

#endif

typedef struct
{
	UINT8	input[17 * 8];
    UINT32	stateTest[50];
} tSimple;

typedef	struct
{
	UINT8	input[MAX_INPUT_LEN];
	UINT8	output[cKeccakR/8];
	UINT8	accu[MIN(cKeccakR/8, 128)];
} tAccumlated;

union
{
	tAccumlated	a;
	tSimple		s;
} u;


int main()
{
    int size;
    int i;
    UINT32 * pStack;

	#if	(cKeccakR == 1024)

	// test size 0
	crypto_hash( (UINT8*)u.s.stateTest, 0, 0  );
	check_result( (UINT8*)u.s.stateTest, outputSize0, 128 );

	// test size 1 byte
	crypto_hash( (UINT8*)u.s.stateTest, inputSize1, 1 );
	check_result( (UINT8*)u.s.stateTest, outputSize1, 128 );

	// test size 128 bytes
	crypto_hash( (UINT8*)u.s.stateTest, inputSize128, 128 );
	check_result( (UINT8*)u.s.stateTest, outputSize128, 128 );

	// test size 255 bytes
	crypto_hash( (UINT8*)u.s.stateTest, inputSize255, 255 );
	check_result( (UINT8*)u.s.stateTest, outputSize255, 128 );

	#endif

	//	Acumulated test vector for crypto_hash()
	memset( u.a.accu, 0x00, sizeof(u.a.accu) );

	for ( size = 0; size <= sizeof(u.a.input); ++size )
	{

		for ( i = 0; i < size; ++i )
		{
			u.a.input[i] = (UINT8)(i - size);
		}

		crypto_hash( u.a.output, u.a.input, size );

		for ( i = 0; i < MIN(cKeccakR/8, 128); ++i )
		{
			u.a.accu[i] ^= u.a.output[i];
		}
	}
	check_result( u.a.accu, testVectorAccumulated, MIN(cKeccakR/8, 128) );

	return 0;
	for ( ; ; ) ;	//	Everything ok
}

void check_result( UINT8 * result, const UINT8 * reference, UINT32 nBytes )
{
    static UINT64 x = 0;
    int i;

    for( i = 0; i < nBytes; ++i )
	{
        if ( result[i] != reference[i] )
		{
            for( ; ; ) 
            {
				//	Kaccek (aka other algo)
                x++;
            }
		}
	}
}
